<?php
/**
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, 
 * or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License 
 * along with this program.  
 * If not, see <http://www.gnu.org/licenses/>.
 *
 * MADE BY NILORD - LAST UPDATE 22/01/13
 * 	- Email   : nilord@outlook.com
 *	- Twitter : @ImNiLord
 *  - Google+ : https://plus.google.com/117310335847577405511
 * 	
 * IMPORTANT: REQUIRE PHP5 + (using php oop)
 */

if(!defined("IN_MYBB")){
    die("Direct initialization of this file is not allowed.<br /><br />Please make sure IN_MYBB is defined.");
}

$plugins->add_hook('global_start', 'lastTweet_show');
$plugins->add_hook("admin_config_action_handler", "lastTweet_confactions");

/*Information about the plugin*/
function lastTweet_info(){
	return array(
			"name" => "اخر تغريدات تويتر",
			"description" => "يسمح لك بعرض اخر تغريدات لحسابك بتويتر ",
			"website" => "http://community.mybb.com/user-29063.html",
			"author" => "NiLord",
			"authorsite" => "https://twitter.com/ImNiLord",
			"version" => "1.5",
			"guid" => "009ab7b6a7db2702aaa1df3bc2089c1f",
			"compatibility" => "16*"
	);
}

/*Activate Function*/
function lastTweet_activate(){
	global $lang, $db;
	$lang -> load("lastTweet");

	//Lets begin creating a new setting group
	$query = $db->simple_select("settinggroups", "COUNT(*) as rows");
    $rows = $db->fetch_field($query, "rows");

    $new_groupconfig = array(
        'name' => 'lastTweet', 
        'title' => 'اخر تغريدات تويتر',
        'description' => $lang->lt_conf,
        'disporder' => $rows+1,
        'isdefault' => 0
    );

     $group['gid'] = $db->insert_query("settinggroups", $new_groupconfig);

     //Now lets create new options =)
     $new_config = array();

     $new_config[] = array(
     	'name' => "lastTweet_title",
     	'title' => $lang->lt_title,
     	'description' => $lang->lt_description,
     	'optionscode' => 'text',
     	'value' => 'تغريدات المنتدي',
     	'disporder' => 8,
     	'gid' => $group['gid'],
     );
     
     $new_config[] = array(
	    'name' => 'lastTweet_date',
	    'title' => $lang->lt_showdate,
	    'description' => $lang->lt_showdatedes,
	    'optionscode' => 'yesno',
	    'value' => '0',
	    'disporder' => 9,
	    'gid' => $group['gid'],
	); 

     $new_config[] = array(
     	'name' => "lastTweet_url",
     	'title' => $lang->lt_url,
     	'description' => $lang->lt_urldescription,
     	'optionscode' => 'text',
     	'value' => 'http://www.twitter.com/ImNiLord',
     	'disporder' => 10,
     	'gid' => $group['gid'],
     );

     $new_config[] = array(
     	'name' => "lastTweet_account",
     	'title' => $lang->lt_account,
     	'description' => $lang->lt_acdescription,
     	'optionscode' => 'text',
     	'value' => 'ImNiLord',
     	'disporder' => 11,
     	'gid' => $group['gid'],
     );

     $new_config[] = array(
     	'name' => "lastTweet_refresh",
     	'title' => $lang->lt_refresh,
     	'description' => $lang->lt_refreshdes,
     	'optionscode' => 'text',
     	'value' => '10',
     	'disporder' => 12,
     	'gid' => $group['gid'],
     );

     $new_config[] = array(
	    'name' => 'lastTweet_lastone',
	    'title' => $lang->lt_lastTweet,
	    'description' => $lang->lt_lastTweetdes,
	    'optionscode' => 'text',
	    'value' => '',
	    'disporder' => 13,
	    'gid' => $group['gid'],
	); 

    //Lets insert each configuration, just 5 right now maybe more later =)
    foreach($new_config as $array => $content)
    {
    	$db->insert_query("settings", $content);
    }

    require MYBB_ROOT."/inc/adminfunctions_templates.php";
	find_replace_templatesets('index', '#{\$header}#', '{$header}
		<!--Begin LastTweet ShowTweet-->
			<style type="text/css">
				.lastTweet {
					background: rgb(213,234,164); 
					background: -moz-linear-gradient(top,  rgba(213,234,164,1) 0%, rgba(205,235,139,1) 100%);
					background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,rgba(213,234,164,1)), color-stop(100%,rgba(205,235,139,1))); 
					background: -webkit-linear-gradient(top,  rgba(213,234,164,1) 0%,rgba(205,235,139,1) 100%); 
					background: -o-linear-gradient(top,  rgba(213,234,164,1) 0%,rgba(205,235,139,1) 100%); 
					background: -ms-linear-gradient(top,  rgba(213,234,164,1) 0%,rgba(205,235,139,1) 100%); 
					background: linear-gradient(to bottom,  rgba(213,234,164,1) 0%,rgba(205,235,139,1) 100%); 
					filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=  "#d5eaa4", endColorstr="#cdeb8b",GradientType=0 ); 
					;font-size: 11px;font-family: tahoma;color: #557A26;text-shadow: 1px 1px 1px rgba(255, 255, 255, 0.24);padding: 15px 10px;border: 1px solid #BDD685;border-radius: 3px;
				}

				.lttitle {
				    font-size: 15px;
				    text-shadow: 1px 1px 1px rgba(255, 255, 255, 0.41);
				}	
			</style>
			<div class="lastTweet">
				<span class="lttitle">{$lttitle}</span>{$ltdate}<br>
				{$ltshow}
			</div><br />
		<!--Finish LastTweet ShowTweet-->');

	// rebuild settings...
	rebuild_settings();
	
    return TRUE;
}

/*Desactivate Function*/
function lastTweet_deactivate(){
	global $db;

	//Deleating option groups...
	$query = $db->simple_select("settinggroups", "gid", "name = \"lastTweet\"");
	$rows = $db->fetch_field($query, "gid");

	$db->delete_query("settinggroups", "gid = {$rows}");

	//Deleting settings
	$db->delete_query("settings", "gid = {$rows}");

	require MYBB_ROOT."/inc/adminfunctions_templates.php";
	
	//Deleting template modifications
	find_replace_templatesets('index', '#' . preg_quote('
			<div class="lastTweet">
				<span class="lttitle">{$lttitle}</span>{$ltdate}<br>
				{$ltshow}
			</div><br />
		<!--Finish LastTweet ShowTweet-->') . '#', '');

	// rebuild settings...
   rebuild_settings();
    
   return TRUE;
}

/*This function show the lastTweet using the account user selected*/
function lastTweet_show(){
	global $mybb, $db, $ltshow, $lttitle, $lang, $ltdate;
	//LastTweet class
	require("lastTweet/class.lastTweet.php");

	//Wanna know the title user assign in acp
	$lttitle = ($mybb->settings['lastTweet_url'] != "") ? '<a href="'.$mybb->settings['lastTweet_url'].'">'.$mybb->settings['lastTweet_title'].'</a>' : $mybb->settings['lastTweet_title'];
	
	//Do i need to reload?
	$query = $db->simple_select('settings', 'value', "name='lastTweet_lastone'");
	$data = $db->fetch_array($query);
	if($data['value'] != ""){
		$info = explode('|', $data['value']);
		if(lastTweet_difminutes($info[2]) < $mybb->settings['lastTweet_refresh']){
			$ltshow = $info[0];
			$ltdate = ($mybb->settings['lastTweet_date'] != "0") ? " - ".$info[1] : "";
			$done = true;
		}
	}

	//It's time to refresh? if it's true lets make a query
	if(!$done){
		try{
			$tweet = new lastTweet($mybb->settings['lastTweet_account']);
			$ltshow = $tweet->getTweet('text');
			$ltdate = ($mybb->settings['lastTweet_date'] != "0") ? " - ".$tweet->getTweet('created_at') : "";

			/*Lets save this in our database*/
			$db->update_query('settings', array('value' => $tweet->getTweet('text')."|".$tweet->getTweet('created_at')."|".time()), "name = 'lastTweet_lastone'");
			$mybb->settings['lastTweet_lastone'] = $tweet->getTweet('text')."|".$tweet->getTweet('created_at')."|".time();
		}catch(Exception $e){
			$show = "ERROR CODE: 34";
		}
	}
}

function lastTweet_difminutes($savedTime){
	return (time()-$savedTime) / 60;
}

function lastTweet_confactions($actions)
{
	$actions['sabias_que'] = array('active' => 'lastTweet', 'file' => 'lastTweet.php');
	return $actions;
}		
?>